package gov.va.vinci.dart.usr.mock;

import gov.va.vinci.dart.common.exception.ObjectNotFoundException;
import gov.va.vinci.dart.biz.Location;
import gov.va.vinci.dart.biz.Person;
import gov.va.vinci.dart.service.DartObjectFactory;
import gov.va.vinci.dart.usr.CustomAuthentication;
import gov.va.vinci.dart.usr.UserManager;
import gov.va.vinci.dart.usr.UserPreferences;
import gov.va.vinci.dart.usr.UserPreferencesImpl;
import gov.va.vinci.security.providers.ad.UserPrincipalName;
import gov.va.vinci.security.userdetails.UserDetails;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class UserManagerMock implements UserManager {

	@Autowired(required=false)
	private String emailAddr;
	
	public void setEmailAddr(final String addr) {
		this.emailAddr = addr;
	}
	
	@Override
	public CustomAuthentication login(CustomAuthentication token)
			throws Exception {

		UserPreferences preferences = new UserPreferencesImpl();
		token.setUserPreferences(preferences);

		String username = Xoken.getName();
		
		// usernames occasionally are presented with AD domain names preceding them so use UserPrincipalName to parse.
		UserPrincipalName upn = new UserPrincipalName(username);

		Person pers = null;
		
		try {
			pers = DartObjectFactory.getInstance().getPersonDAO().findByNameCaseInsensitive(upn.getUserName());
		} catch (ObjectNotFoundException e) {
			// person not found - add them
			Location loc = Location.findById(1);  // TODO- get the correct location id
			pers = Person.create(upn.getUserName(), "Username, Automatically Created", loc);
		}
		
		preferences.setUserId(pers.getId());
		preferences.setUserLoginId(upn.getUserName()); 
		preferences.setUserFullName(pers.getFullName());
		
		if (emailAddr != null) {
			preferences.setUserEmailAddress(emailAddr);
		}
		else {
			preferences.setUserEmailAddress(upn.getUserName() + "@hotmail.com");
		}
		
		return token;
	}

	@Override
	public void login(String username, String password) throws Exception {
		
	}

	@Override
	public UserDetails getUserDetails(String username) throws Exception {
		
		UserDetails result = new UserDetails();
		
		Person pers = DartObjectFactory.getInstance().getPersonDAO().findByNameCaseInsensitive(username);
		result.setFullName(pers.getFullName());
		if (emailAddr != null) {
			result.setEmailAddress(emailAddr);
		}
		else {
			result.setEmailAddress(username + "@hotmail.com");
		}
		result.setUserId(username);
		result.setUsername(username);
		
		return result;
	}

	@Override
	public List<String[]> searchUsers(String username) throws Exception {
		List<String[]> result = new ArrayList<String[]>();
		
		for (Person pers : DartObjectFactory.getInstance().getPersonDAO().listAll()) {
			
			// case insensitive prefix match on username
			if (StringUtils.startsWithIgnoreCase(pers.getFullName(), username) == true) {
				String[] res1 = new String[2];
				res1[0] = pers.getName();
				res1[1] = pers.getFullName();
				result.add(res1);
			}
		}
		
		// TODO- you really should return this list sorted
		
		return result;
	}

}
